/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

// COMClientView.cpp : implementation of the CCOMClientView class
//

#include "stdafx.h"
#include "CClient.h"

#include "CClientDoc.h"
#include "CClientView.h"
#include "MainFrm.h"

#include "CConvenienceExports.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

BOOL runDw = TRUE, closeDw = FALSE;

/////////////////////////////////////////////////////////////////////////////
// CCOMClientView

IMPLEMENT_DYNCREATE(CCOMClientView, CView)

BEGIN_MESSAGE_MAP(CCOMClientView, CView)
	//{{AFX_MSG_MAP(CCOMClientView)
	ON_COMMAND(ID_ADIM, OnAdim)
	ON_COMMAND(ID_CLOSEDW, OnClosedw)
	ON_COMMAND(ID_CONE, OnCone)
	ON_COMMAND(ID_CYL, OnCyl)
	ON_COMMAND(ID_DATUM, OnDatum)
	ON_COMMAND(ID_DDIM, OnDdim)
	ON_COMMAND(ID_GEOMTOL, OnGeomtol)
	ON_COMMAND(ID_LDIM, OnLdim)
	ON_COMMAND(ID_NOTE, OnNote)
	ON_COMMAND(ID_RDIM, OnRdim)
	ON_COMMAND(ID_RECT, OnRect)
	ON_COMMAND(ID_RUN, OnRun)
	ON_COMMAND(ID_TOROUS, OnTorous)
	ON_COMMAND(ID_PARTCLOSE, OnPartclose)
	ON_COMMAND(ID_PARTOPEN, OnPartopen)
	ON_COMMAND(ID_PARTSAVE, OnPartsave)
	ON_COMMAND(ID_SPINDLE, OnSpindle)
	ON_COMMAND(ID_WHEEL, OnWheel)
	ON_COMMAND(ID_ADDCOMPONENT, OnAddcomponent)
	ON_COMMAND(ID_SPWHASSEMBLY, OnSpwhassembly)
	ON_COMMAND(ID_DRAWINGCLOSE, OnDrawingclose)
	ON_COMMAND(ID_DRAWINGOPEN, OnDrawingopen)
	ON_COMMAND(ID_DRAWINGSAVE, OnDrawingsave)
	ON_COMMAND(ID_DRAWINGSAVEAS, OnDrawingsaveas)
	ON_COMMAND(ID_PARTSAVEAS, OnPartsaveas)
	ON_COMMAND(ID_NEWDRAWING, OnNewdrawing)
	ON_COMMAND(ID_NEWPART, OnNewpart)
	ON_COMMAND(ID_SETDRAWINGNAME, OnSetdrawingname)
	ON_COMMAND(ID_SETDRAWINGTITLE, OnSetdrawingtitle)
	ON_COMMAND(ID_SETPARTNAME, OnSetpartname)
	ON_COMMAND(ID_SETPARTTITLE, OnSetparttitle)
	ON_COMMAND(ID_ALIGNPLANES, OnAlignplanes)
	ON_COMMAND(ID_CENTERAXES, OnCenteraxes)
	ON_COMMAND(ID_MASSPROPERTIES, OnMassproperties)
	ON_COMMAND(ID_MATEPLANES, OnMateplanes)
	ON_COMMAND(ID_ORIENTAXES, OnOrientaxes)
	ON_COMMAND(ID_NEW_SKETCH, OnNewSketch)
	ON_COMMAND(ID_CREATE_EXTRUSION, OnCreateExtrusion)
	ON_COMMAND(ID_CREATE_HOLE, OnCreateHole)
	ON_COMMAND(ID_CREATE_PROJECTION, OnCreateProjection)
	ON_COMMAND(ID_CREATE_REVOLUTION, OnCreateRevolution)
	ON_COMMAND(ID_CREATE_SIMPLE_BLEND, OnCreateSimpleBlend)
	ON_COMMAND(ID_CREATE_SWEEP, OnCreateSweep)
	ON_COMMAND(ID_CREATE_VARIABLE_BLEND, OnCreateVariableBlend)
	ON_COMMAND(ID_HIDE_OTHER_SKETCHES, OnHideOtherSketches)
	ON_COMMAND(ID_MID_PLANE, OnMidPlane)
	ON_COMMAND(ID_OFFSET_PLANE, OnOffsetPlane)
	ON_COMMAND(ID_ORIENTED_PLANE, OnOrientedPlane)
	ON_COMMAND(ID_PLANE_OF_OBJECT, OnPlaneOfObject)
	ON_COMMAND(ID_PLANE_THROUGH_OBJECTS, OnPlaneThroughObjects)
	ON_COMMAND(ID_REPOSITION_AXES, OnRepositionAxes)
	ON_COMMAND(ID_REVERSE_AXES, OnReverseAxes)
	ON_COMMAND(ID_ROTATE_AXES, OnRotateAxes)
	ON_COMMAND(ID_TRANSLATE_AXES, OnTranslateAxes)
	ON_COMMAND(ID_UNCONDEMN_ALL, OnUncondemnAll)
	ON_COMMAND(ID_UPDATE_DESIGN, OnUpdateDesign)
	ON_COMMAND(ID_HOLLOW, OnHollow)
	ON_COMMAND(ID_USECOMPONENT, OnUsecomponent)
	ON_COMMAND(ID_CREATE_LINE, OnCreateLine)
	ON_COMMAND(ID_CREATE_CIRCLE, OnCreateCircle)
	ON_COMMAND(ID_CREATE_RECTANGLE, OnCreateRectangle)
	ON_COMMAND(ID_CREATE_ARC_START_END_CENTER, OnCreateArcStartEndCenter)
	ON_COMMAND(ID_DELETE_LINES, OnDeleteLines)
	ON_COMMAND(ID_OFFSET_CHAIN, OnOffsetChain)
	ON_COMMAND(ID_TRANSLATE_OBJECTS, OnTranslateObjects)
	ON_COMMAND(ID_ROTATE_OBJECTS, OnRotateObjects)
	ON_COMMAND(ID_SCALE_OBJECTS, OnScaleObjects)
	ON_COMMAND(ID_RECTANGULAR_DUPLICATE, OnRectangularDuplicate)
	ON_COMMAND(ID_CIRCULAR_DUPLICATE, OnCircularDuplicate)
	ON_COMMAND(ID_MIRROR_IN_X, OnMirrorInX)
	ON_COMMAND(ID_MIRROR_IN_Y, OnMirrorInY)
	ON_COMMAND(ID_MIRROR_IN_BOTH, OnMirrorInBoth)
	ON_COMMAND(ID_MAKE_PARALLEL, OnMakeParallel)
	ON_COMMAND(ID_MAKE_PERPENDICULAR, OnMakePerpendicular)
	ON_COMMAND(ID_MAKE_COLINEAR, OnMakeColinear)
	ON_COMMAND(ID_MAKE_TANGENT_LINE_CIRCLE, OnMakeTangentLineCircle)
	ON_COMMAND(ID_MAKE_TANGENT_CIRCLE_CIRCLE, OnMakeTangentCircleCircle)
	ON_COMMAND(ID_MAKE_CONCENTRIC, OnMakeConcentric)
	ON_COMMAND(ID_MAKE_EQUAL_LENGTH, OnMakeEqualLength)
	ON_COMMAND(ID_MAKE_EQUAL_RADIUS, OnMakeEqualRadius)
	ON_COMMAND(ID_FIX_LINE, OnFixLine)
	ON_COMMAND(ID_CONSTRAIN_SIZE, OnConstrainSize)
	ON_COMMAND(ID_CONSTRAIN_SEPARATION_POINT_TO_POINT, OnConstrainSeparationPointToPoint)
	ON_COMMAND(ID_CONSTRAIN_SEPARATION_POINT_TO_LINE, OnConstrainSeparationPointToLine)
	ON_COMMAND(ID_CONSTRAIN_SEPARATION_LINE_TO_LINE, OnConstrainSeparationLineToLine)
	ON_COMMAND(ID_MAKE_RADIAL_DIM, OnMakeRadialDim)
	ON_COMMAND(ID_MAKE_ANGULAR_DIM, OnMakeAngularDim)
	ON_COMMAND(ID_CREATE_LINE_START_TO_START, OnCreateLineStartToStart)
	ON_COMMAND(ID_CREATE_LINE_START_TO_MIDDLE, OnCreateLineStartToMiddle)
	ON_COMMAND(ID_CREATE_LINE_START_TO_END, OnCreateLineStartToEnd)
	ON_COMMAND(ID_CREATE_LINE_MIDDLE_TO_START, OnCreateLineMiddleToStart)
	ON_COMMAND(ID_CREATE_LINE_MIDDLE_TO_MIDDLE, OnCreateLineMiddleToMiddle)
	ON_COMMAND(ID_CREATE_LINE_MIDDLE_TO_END, OnCreateLineMiddleToEnd)
	ON_COMMAND(ID_CREATE_LINE_END_TO_START, OnCreateLineEndToStart)
	ON_COMMAND(ID_CREATE_LINE_END_TO_MIDDLE, OnCreateLineEndToMiddle)
	ON_COMMAND(ID_CREATE_LINE_END_TO_END, OnCreateLineEndToEnd)
	ON_COMMAND(ID_CREATE_LINE_CENTER_TO_START, OnCreateLineCenterToStart)
	ON_COMMAND(ID_CREATE_LINE_CENTER_TO_MIDDLE, OnCreateLineCenterToMiddle)
	ON_COMMAND(ID_CREATE_LINE_CENTER_TO_END, OnCreateLineCenterToEnd)
	ON_COMMAND(ID_CREATE_LINE_START_TO_CENTER, OnCreateLineStartToCenter)
	ON_COMMAND(ID_CREATE_LINE_MIDDLE_TO_CENTER, OnCreateLineMiddleToCenter)
	ON_COMMAND(ID_CREATE_LINE_END_TO_CENTER, OnCreateLineEndToCenter)
	ON_COMMAND(ID_CREATE_LINE_CENTER_TO_CENTER, OnCreateLineCenterToCenter)
	ON_COMMAND(ID_GEAR_DESIGN, OnGearDesign)
	ON_UPDATE_COMMAND_UI(ID_RUN, OnUpdateRun)
	ON_UPDATE_COMMAND_UI(ID_CLOSEDW, OnUpdateClosedw)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCOMClientView construction/destruction

CCOMClientView::CCOMClientView()
{
	// TODO: add construction code here

}

CCOMClientView::~CCOMClientView()
{
}

BOOL CCOMClientView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CCOMClientView drawing

void CCOMClientView::OnDraw(CDC* pDC)
{
	CCOMClientDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
}


#ifdef _DEBUG
void CCOMClientView::AssertValid() const
{
	CView::AssertValid();
}

void CCOMClientView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CCOMClientDoc* CCOMClientView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CCOMClientDoc)));
	return (CCOMClientDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CCOMClientView message handlers

void CCOMClientView::OnAdim() 
{
	//
}

void CCOMClientView::OnCone() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = CreateCone();
	if(status)
		AfxMessageBox("CreateCone failed");
	
	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCyl() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = CreateCylinder();
	if(status)
		AfxMessageBox("CreateCylinder failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnDatum() 
{
	//
}

void CCOMClientView::OnDdim() 
{
	if (GetHelmProDESKTOP()) 
		return;
	
	HRESULT status = TestDrawingDiametricCF();
	if(status)
		AfxMessageBox("Diametric Dimension failed");
	
	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnGeomtol() 
{
	if (GetHelmProDESKTOP()) 
		return;
	
	HRESULT status = TestDrawingGeomTolCF();
	if(status)
		AfxMessageBox("Geometrical Tolerance failed");
	
	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnLdim() 
{
	//
}

void CCOMClientView::OnNote() 
{
	if (GetHelmProDESKTOP()) 
		return;
	
	HRESULT status = TestDrawingNoteCF();
	if(status)
		AfxMessageBox("Note failed");
	
	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnRdim() 
{
	if (GetHelmProDESKTOP()) 
		return;
	
	HRESULT status = TestDrawingRadialCF();
	if(status)
		AfxMessageBox("Radial Dimension failed");
	
	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnRect() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = RectangularBlock();
	if(status)
		AfxMessageBox("CreateRectangleBlock failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnRun() 
{
	IApplication *app = NULL;
	HRESULT status = RunProDESKTOP(&app);
	if(status || !app)
		AfxMessageBox("Pro/DESKTOP could not be started");

	runDw = FALSE;
	closeDw = TRUE;
}

void CCOMClientView::OnTorous() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = Torous();
	if(status)
		AfxMessageBox("CreateTorus failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnPartclose() 
{
	HRESULT status = PartClose();
	if(status)
		AfxMessageBox("PartClose failed");
}

void CCOMClientView::OnPartopen() 
{
	CString filename;
	IPartDocument *pdisp = NULL;
	CString filter;
	VERIFY(filter.LoadString(IDS_PartsFileDesc));
	CFileDialog dlg(TRUE, NULL, NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, filter);
	if(dlg.DoModal() == TRUE) {
		filename = dlg.GetPathName();
	}
	else 
		return;
	
	HRESULT status = PartOpen(filename,&pdisp);
	if(status)
		AfxMessageBox("PartOpen failed");
}

void CCOMClientView::OnPartsave() 
{
	//
}
void CCOMClientView::OnClosedw() 
{
	HRESULT status = CloseProDESKTOP();
	if(status)
		AfxMessageBox("Pro/DESKTOP could not be shut down");

	runDw = TRUE;
	closeDw = FALSE;
}

void CCOMClientView::OnSpindle() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = Spindle();	
	if(status)
		AfxMessageBox("Spindle failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnWheel() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = Wheel();	
	if(status)
		AfxMessageBox("Wheel failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnAddcomponent() 
{
	if (GetHelmProDESKTOP()) 
		return;

	CString str;
	IDesign *pdisp = NULL;
	CString filter;
	VERIFY(filter.LoadString(IDS_PartsFileDesc));
	CFileDialog dlg(TRUE, NULL, NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, filter);

	if(dlg.DoModal() == TRUE) {
		str = dlg.GetPathName();
	}
	else 
		return;
	if (!str.IsEmpty()) {
		HRESULT status = AddComponent(str,&pdisp);
		if(status)
			AfxMessageBox("AddComponent failed");
	}
	if(CommitToProDESKTOP("AddComponent"))
		return;

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnSpwhassembly() 
{
	DemoSpindleWheelAssembly();
}

void CCOMClientView::OnDrawingclose() 
{
	 HRESULT status = DrawingClose();
	 if(status)
		AfxMessageBox("DrawingClose failed");
}

void CCOMClientView::OnDrawingopen() 
{
	CString filename;
	IDrawingDocument *pdisp = NULL;
	CString filter;
	VERIFY(filter.LoadString(IDS_DrawingsFileDesc));
	CFileDialog dlg(TRUE, NULL, NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, filter);

	if(dlg.DoModal() == TRUE) {
			filename = dlg.GetPathName();
	}
	else 
		return;

	HRESULT status = DrawingOpen(filename,&pdisp);
	if(status)
		AfxMessageBox("DrawingOpen failed");
}

void CCOMClientView::OnDrawingsave() 
{
	//
}

void CCOMClientView::OnDrawingsaveas() 
{
	//
}

void CCOMClientView::OnPartsaveas() 
{
	//
}

void CCOMClientView::OnNewdrawing() 
{
	HRESULT status = TestNewDrawing();
	if(status)
		AfxMessageBox("NewDrawing failed");
}

void CCOMClientView::OnNewpart() 
{
	HRESULT status = TestNewPart();	
	if(status)
		AfxMessageBox("NewPart failed");
}

void CCOMClientView::OnSetdrawingname() 
{
	// method removed
}

void CCOMClientView::OnSetdrawingtitle() 
{
	// method removed	
}

void CCOMClientView::OnSetpartname() 
{
	// method removed
}

void CCOMClientView::OnSetparttitle() 
{
	// method removed
}

void CCOMClientView::OnAlignplanes() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = AlignPlanesPrior();
	if(status)
		AfxMessageBox("AlignPlanes failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCenteraxes() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = centerAxesPrior();
	if(status)
		AfxMessageBox("CenterAxes failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnMassproperties() 
{
	HRESULT status = NOERROR;
//	double density = 2.00;
	double mass = 0.0, volume = 0.0, area = 0.0;
	IVector *cofgPoint = NULL, *principalMomentsOfInertia = NULL;
	IVector *radiusOfGyration = NULL;
	IMatrix *momentOfInertia = NULL, *principalAxes = NULL;

	status = Massproperties(&mass, &volume, &area, cofgPoint,
		momentOfInertia, principalMomentsOfInertia, principalAxes,
		radiusOfGyration);

	if (status) {
		AfxMessageBox("Massproperties failed");
		return ;
	}

	CString strmass;
	strmass.Format("\nMass = %f", mass);
	volume = volume * 1000000000 ;        //("The Volume in mm3 = "  
	CString strvolume;
	strvolume.Format("\nVolume = %f", volume);
	area = area * 1000000 ;            //("The Area in mm2 = " 
	CString strarea;
	strarea.Format("\nArea = %f", area);
	CString caption = "\n      MASS   PROPERTIES \n\n" ;
	CString str = caption + strmass + strvolume + strarea ;
	AfxMessageBox(str);
}

void CCOMClientView::OnMateplanes() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = MatePlanesPrior();
	if(status)
		AfxMessageBox("MatePlanes failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnOrientaxes() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = OrientAxesPrior();
	if(status)
		AfxMessageBox("OrientAxes failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnNewSketch() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = TestNewSketch();
	if(status)
		AfxMessageBox("NewSketch failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCreateExtrusion() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = TestExtrusion();
	if(status)
		AfxMessageBox("CreateExtrusion failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCreateHole() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = TestHole();
	if(status)
		AfxMessageBox("CreateHole failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCreateProjection() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = TestProjection();
	if(status)
		AfxMessageBox("CreateProjection failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCreateRevolution() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = TestRevolutionToDrawCone();
	if(status)
		AfxMessageBox("CreateRevolution failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCreateSimpleBlend() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = TestSimpleBlend();
	if(status)
		AfxMessageBox("CreateBlend failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCreateSweep() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = TestSweepToDrawPrism();
	if(status)
		AfxMessageBox("CreateSweep failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCreateVariableBlend() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = TestVariableBlend();
	if(status)
		AfxMessageBox("CreateBlend failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnHideOtherSketches() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = TestHideOtherSketches();
	if(status)
		AfxMessageBox("HideOtherSketches failed");
	
	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnMidPlane() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = TestMidplane();
	if(status)
		AfxMessageBox("CreateMidPlane failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnOffsetPlane() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = TestOffsetplane();
	if(status)
		AfxMessageBox("CreateOffsetPlane failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnOrientedPlane() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = TestOrientedplane();
	if(status)
		AfxMessageBox("CreateOrientedPlane failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnPlaneOfObject() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = TestPlaneOfObject();
	if(status)
		AfxMessageBox("CreatePlaneOfObject failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnPlaneThroughObjects() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = TestPlaneThroughObjects();
	if(status)
		AfxMessageBox("CreatePlaneThroughObjects failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnRepositionAxes() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status= TestRepositionAxes();
	if(status)
		AfxMessageBox("RepositionAxes failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnReverseAxes() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = TestReverseAxes();
	if(status)
		AfxMessageBox("ReverseAxes failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnRotateAxes() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = TestRotateAxes();
	if(status)
		AfxMessageBox("RotateAxes failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnTranslateAxes() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = TestTranslateAxes();
	if(status)
		AfxMessageBox("TranslateAxes failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnUncondemnAll() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = TestUncondemnAll();
	if(status)
		AfxMessageBox("UnCondemnAll failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnUpdateDesign() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = UpdateDesign();
	if(status)
		AfxMessageBox("UpdateDesign failed");

	status = CommitToProDESKTOP("UpdateDesign");

	if (ReleaseHelmProDESKTOP()) 
		return;
}
void CCOMClientView::OnHollow() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = TestHollow();
	if(status)
		AfxMessageBox("CreateHollow failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnUsecomponent() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = TestUseComponent();
	if(status)
		AfxMessageBox("UseComponent failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}


//-------------------------------------------------------------------------------------

// Line Convenience Functions

void CCOMClientView::OnCreateLine() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ILine *line1 = NULL;
	double startX = 0, startY = 0, endX = 0, endY = 0;

	status = GetCreateLineInput(&startX, &startY, &endX, &endY);

	if(!status) {

		status = CreateLine(startX, startY, endX, endY, &line1);
		if(status || !line1)
			AfxMessageBox("CreateLine failed");

		if(CommitToProDESKTOP("CreateLine"))
			return;
	}
	else
		AfxMessageBox("CreateLine failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCreateCircle() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ILine *circle1 = NULL;
	double centerX = 0, centerY = 0, radius =0;

	status = GetCreateCircleInput(&centerX, &centerY, &radius);

	if(!status) {

		status = CreateCircle(centerX, centerY, radius, &circle1);
		if(status || !circle1)
			AfxMessageBox("CreateCircle failed");

		if(CommitToProDESKTOP("CreateCircle"))
			return;
	}
	else
		AfxMessageBox("CreateCircle failed");;

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCreateRectangle() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ISet *rectangle1 = NULL;
	double topLeftX = 0, topLeftY = 0, bottomRightX = 0, bottomRightY = 0;

	status = GetCreateRectangleInput(&topLeftX, &topLeftY, &bottomRightX, &bottomRightY);

	if(!status) {

		status = CreateRectangle(topLeftX, topLeftY, bottomRightX, bottomRightY, &rectangle1);
		if(status || !rectangle1)
			AfxMessageBox("CreateRectangle failed");

		if(CommitToProDESKTOP("CreateRectangle"))
			return;
	}
	else
		AfxMessageBox("CreateRectangle failed");;

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCreateArcStartEndCenter() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ILine *arc1 = NULL;
	IPoint *startPoint = NULL;

	IPoint *endPoint = NULL;
	IPoint *center = NULL;

	status = GetCreateArcStartEndCenterInput(&startPoint, &endPoint, &center);

	if(!status) {

		status = CreateArcStartEndCenter(startPoint, endPoint, center, &arc1);
		if(status || !arc1)
			AfxMessageBox("CreateArcStartEndCenter failed");

		if(CommitToProDESKTOP("CreateArcStartEndCenter"))
			return;
	}
	else
		AfxMessageBox("CreateArcStartEndCenter failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}


//-------------------------------------------------------------------------------------

// Edit Convenience Functions

void CCOMClientView::OnDeleteLines() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ISet *objectSet1 = NULL;

	status = GetDeleteLinesInput(&objectSet1);

	if(!status) {

		status = DeleteLines(objectSet1);
		if(status)
			AfxMessageBox("DeleteLines failed");

		if(CommitToProDESKTOP("DeleteLines"))
			return;
	}
	else
		AfxMessageBox("DeleteLines failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnOffsetChain() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ISet *objectSet1 = NULL;
	double distance =0;
	long direction = 0;

	status = GetOffsetChainInput(&objectSet1, &distance, &direction);

	if(!status) {

		status = OffsetChain(objectSet1, distance, direction);
		if(status)
			AfxMessageBox("OffsetChain failed");

		if(CommitToProDESKTOP("OffsetChain"))
			return;
	}
	else
		AfxMessageBox("OffsetChain failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnTranslateObjects() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ISet *objectSet1 = NULL;
	double xDistance = 0, yDistance = 0;

	status = GetTranslateObjectsInput(&xDistance, &yDistance, &objectSet1);

	if(!status) {

		status = TranslateObjects(xDistance, yDistance, objectSet1);
		if(status)
			AfxMessageBox("TranslateObjects failed");

		if(CommitToProDESKTOP("TranslateObjects"))
			return;
	}
	else
		AfxMessageBox("TranslateObjects failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnRotateObjects() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ISet *objectSet1 = NULL;
	double angle = 0;

	status = GetRotateObjectsInput(&angle, &objectSet1);

	if(!status) {

		status = RotateObjects(angle, objectSet1);
		if(status)
			AfxMessageBox("RotateObjects failed");

		if(CommitToProDESKTOP("RotateObjects"))
			return;
	}
	else
		AfxMessageBox("RotateObjects failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnScaleObjects() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ISet *objectSet1 = NULL;
	double scaleFactor = 0;

	status = GetScaleObjectsInput(&scaleFactor, &objectSet1);

	if(!status) {

		status = ScaleObjects(scaleFactor, objectSet1);
		if(status)
			AfxMessageBox("ScaleObjects failed");

		if(CommitToProDESKTOP("ScaleObjects"))
			return;
	}
	else
		AfxMessageBox("ScaleObjects failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnRectangularDuplicate() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ISet *objectSet1 = NULL;
	double xNumber = 0, yNumber = 0, xSpacing = 0, ySpacing = 0;

	status = GetRectangularDuplicateInput(&xNumber, &yNumber,
		&xSpacing, &ySpacing, &objectSet1);

	if(!status){

		status = RectangularDuplicate(xNumber, yNumber, xSpacing, ySpacing, objectSet1);
		if(status)
			AfxMessageBox("RectangularDuplicate failed");

		if(CommitToProDESKTOP("RectangularDuplicate"))
			return;
	}
	else
		AfxMessageBox("RectangularDuplicate failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCircularDuplicate() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ISet *objectSet1 = NULL;

	long number = 0;
	double angle = 0;
	BOOL isTotalAngle = TRUE;

	status = GetCircularDuplicateInput(&number, &angle, &isTotalAngle, &objectSet1);

	if(!status) {

		status = CircularDuplicate(number, angle, isTotalAngle, objectSet1);
		if(status)
			AfxMessageBox("CircularDuplicate failed");

		if(CommitToProDESKTOP("CircularDuplicate"))
			return;
	}
	else
		AfxMessageBox("CircularDuplicate failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnMirrorInX() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ISet *aLineSet1 = NULL;
	ISet *aLineSet2 = NULL;

	status = GetMirrorInXInput(&aLineSet1);

	if(!status) {

		status = MirrorInX(aLineSet1, &aLineSet2);
		if(status || !aLineSet2)
			AfxMessageBox("MirrorInX failed");

		if(CommitToProDESKTOP("MirrorInX"))
			return;
	}
	else
		AfxMessageBox("MirrorInX failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnMirrorInY() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ISet *aLineSet1 = NULL;
	ISet *aLineSet2 = NULL;

	status = GetMirrorInYInput(&aLineSet1);

	if(!status) {

		status = MirrorInY(aLineSet1, &aLineSet2);
		if(status || !aLineSet2)
			AfxMessageBox("MirrorInY failed");

		if(CommitToProDESKTOP("MirrorInY"))
			return;
	}
	else
		AfxMessageBox("GetMirrorInYInput function failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnMirrorInBoth() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ISet *aLineSet1 = NULL;
	ISet *aLineSet2 = NULL;

	status = GetMirrorInBothInput(&aLineSet1);

	if(!status) {

		status = MirrorInBoth(aLineSet1, &aLineSet2);
		if(status || !aLineSet2)
			AfxMessageBox("MirrorInBoth failed");

		if(CommitToProDESKTOP("MirrorInBoth"))
			return;
	}
	else
		AfxMessageBox("GetMirrorInBothInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}


//-------------------------------------------------------------------------------------

// Constraints Convenience Methods

void CCOMClientView::OnMakeParallel() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ISet *objectSet = NULL;

	status = GetMakeParallelInput(&objectSet);
	
	if(!status) {

		status = MakeParallel(objectSet);
		if(status)
			AfxMessageBox("MakeParallel failed");

		if(CommitToProDESKTOP("MakeParallel"))
			return;
	}
	else
		AfxMessageBox("GetMakeParallelInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnMakePerpendicular() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ILine *line1 = NULL;
	ILine *line2 = NULL;

	status = GetMakePerpendicularInput(&line1, &line2);

	if(!status) {

		status = MakePerpendicular(line1, line2);
		if(status)
			AfxMessageBox("MakePerpendicular failed");

		if(CommitToProDESKTOP("MakePerpendicular"))
			return;
	}
	else
		AfxMessageBox("GetMakePerpendicularInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnMakeColinear() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ISet *objectSet = NULL;

	status = GetMakeColinearInput(&objectSet);

	if(!status) {

		status = MakeColinear(objectSet);
		if(status)
			AfxMessageBox("MakeColinear failed");

		if(CommitToProDESKTOP("MakeColinear"))
			return;
	}
	else
		AfxMessageBox("GetMakeColinearInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnMakeTangentLineCircle() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ILine *line1 = NULL;
	ILine *circle1 = NULL;

	status = GetMakeTangentLineCircleInput(&line1, &circle1);

	if(!status) {

		status = MakeTangentLineCircle(line1, circle1);
		if(status)
			AfxMessageBox("MakeTangentLineCircle failed");

		if(CommitToProDESKTOP("MakeTangentLineCircle"))
			return;
	}
	else
		AfxMessageBox("GetMakeTangentLineCircleInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnMakeTangentCircleCircle() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ILine *circle1 = NULL;
	ILine *circle2 = NULL;

	status = GetMakeTangentCircleCircleInput(&circle1, &circle2);

	if(!status) {

		status = MakeTangentCircleCircle(circle1, circle2);
		if(status)
			AfxMessageBox("MakeTangentCircleCircle failed");

		if(CommitToProDESKTOP("MakeTangentCircleCircle"))
			return;
	}
	else
		AfxMessageBox("GetMakeTangentCircleCircleInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnMakeConcentric() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ISet *objectSet = NULL;

	status = GetMakeConcentricInput(&objectSet);

	if(!status) {

		status = MakeConcentric(objectSet);
		if(status)
			AfxMessageBox("MakeConcentric failed");

		if(CommitToProDESKTOP("MakeConcentric"))
			return;
	}
	else
		AfxMessageBox("GetMakeConcentricInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnMakeEqualLength() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ISet *objectSet = NULL;

	status = GetMakeEqualLengthInput(&objectSet);

	if(!status) {

		status = MakeEqualLength(objectSet);
		if(status)
			AfxMessageBox("MakeEqualLength failed");

		if(CommitToProDESKTOP("MakeEqualLength"))
			return;
	}
	else
		AfxMessageBox("GetMakeEqualLengthInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnMakeEqualRadius() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ISet *objectSet = NULL;

	status = GetMakeEqualRadiusInput(&objectSet);

	if(!status) {

		status = MakeEqualRadius(objectSet);
		if(status)
			AfxMessageBox("MakeEqualRadius failed");

		if(CommitToProDESKTOP("MakeEqualRadius"))
			return;
	}
	else
		AfxMessageBox("GetMakeEqualRadiusInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnFixLine() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ISet *objectSet = NULL;

	status = GetFixLineInput(&objectSet);

	if(!status) {

		status = FixLine(objectSet);
		if(status)
			AfxMessageBox("FixLine failed");

		if(CommitToProDESKTOP("FixLine"))
			return;
	}
	else
		AfxMessageBox("GetFixLineInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnConstrainSize() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ILine *line = NULL;

	status = GetConstrainSizeInput(&line);

	if(!status) {

		status = ConstrainSize(line);
		if(status)
			AfxMessageBox("ConstrainSize failed");

		if(CommitToProDESKTOP("ConstrainSize"))
			return;
	}
	else
		AfxMessageBox("GetConstrainSizeInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnConstrainSeparationPointToPoint() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	IPoint *point1 = NULL;
	IPoint *point2 = NULL;

	status = GetConstrainSeparationPointToPointInput(&point1, &point2);

	if(!status) {

		status = ConstrainSeparationPointToPoint(point1, point2);
		if(status)
			AfxMessageBox("ConstrainSeparationPointToPoint failed");

		if(CommitToProDESKTOP("ConstrainSeparationPointToPoint"))
			return;
	}
	else
		AfxMessageBox("GetConstrainSeparationPointToPointInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnConstrainSeparationPointToLine() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	IPoint *point1 = NULL;
	ILine *line1 = NULL;

	status = GetConstrainSeparationPointToLineInput(&point1, &line1);

	if(!status) {

		status = ConstrainSeparationPointToLine(point1, line1);
		if(status)
			AfxMessageBox("ConstrainSeparationPointToLine failed");

		if(CommitToProDESKTOP("ConstrainSeparationPointToLine"))
			return;
	}
	else
		AfxMessageBox("GetConstrainSeparationPointToLineInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnConstrainSeparationLineToLine() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ILine *line1 = NULL;
	ILine *line2 = NULL;

	status = GetConstrainSeparationLineToLineInput(&line1, &line2);

	if(!status) {

		status = ConstrainSeparationLineToLine(line1, line2);
		if(status)
			AfxMessageBox("ConstrainSeparationLineToLine failed");

		if(CommitToProDESKTOP("ConstrainSeparationLineToLine"))
			return;
	}
	else
		AfxMessageBox("GetConstrainSeparationLineToLineInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;

}

void CCOMClientView::OnMakeRadialDim() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ILine *circle1 = NULL;

	status = GetMakeRadialDimInput(&circle1);

	if(!status) {

		status = MakeRadialDim(circle1);
		if(status)
			AfxMessageBox("MakeRadialDim failed");

		if(CommitToProDESKTOP("MakeRadialDim"))
			return;
	}
	else
		AfxMessageBox("GetMakeRadialDimInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnMakeAngularDim() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ILine *line1 = NULL;
	ILine *line2 = NULL;

	status = GetMakeAngularDimInput(&line1, &line2);

	if(!status) {

		status = MakeAngularDim(line1, line2);
		if(status)
			AfxMessageBox("MakeAngularDim failed");

		if(CommitToProDESKTOP("MakeAngularDim"))
			return;
	}
	else
		AfxMessageBox("GetMakeAngularDimInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}


//-------------------------------------------------------------------------------------

// Create Line Convenience Methods

void CCOMClientView::OnCreateLineStartToStart() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ILine *newLine1 = NULL;

	ILine *line1 = NULL;
	ILine *line2 = NULL;

	status = GetCreateLineStartToStartInput(&line1, &line2);

	if(!status) {

		status = CreateLineStartToStart(line1, line2, &newLine1);
		if(status || !newLine1)
			AfxMessageBox("CreateLineStartToStart failed");

		if(CommitToProDESKTOP("CreateLineStartToStart"))
			return;
	}
	else
		AfxMessageBox("GetCreateLineStartToStartInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCreateLineStartToMiddle() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ILine *newLine1 = NULL;
	ILine *line1 = NULL;
	ILine *line2 = NULL;

	status = GetCreateLineStartToMiddleInput(&line1, &line2);
	if(!status) {

		status = CreateLineStartToMiddle(line1, line2, &newLine1);
		if(status || !newLine1)
			AfxMessageBox("CreateLineStartToMiddle failed");

		if(CommitToProDESKTOP("CreateLineStartToMiddle"))
			return;
	}
	else
		AfxMessageBox("GetCreateLineStartToMiddleInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCreateLineStartToEnd() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ILine *newLine1 = NULL;

	ILine *line1 = NULL;
	ILine *line2 = NULL;

	status = GetCreateLineStartToEndInput(&line1, &line2);
	if(!status) {

		status = CreateLineStartToEnd(line1, line2, &newLine1);
		if(status || !newLine1)
			AfxMessageBox("CreateLineStartToEnd failed");

		if(CommitToProDESKTOP("CreateLineStartToEnd"))
			return;
	}
	else
		AfxMessageBox("GetCreateLineStartToEndInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCreateLineMiddleToStart() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ILine *newLine1 = NULL;

	ILine *line1 = NULL;
	ILine *line2 = NULL;

	status = GetCreateLineMiddleToStartInput(&line1, &line2);

	if(!status) {

		status = CreateLineMiddleToStart(line1, line2, &newLine1);
		if(status || !newLine1)
			AfxMessageBox("CreateLineMiddleToStart failed");

		if(CommitToProDESKTOP("CreateLineMiddleToStart"))
			return;
	}
	else
		AfxMessageBox("GetCreateLineMiddleToStartInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCreateLineMiddleToMiddle() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ILine *newLine1 = NULL;
	
	ILine *line1 = NULL;
	ILine *line2 = NULL;

	status = GetCreateLineMiddleToMiddleInput(&line1, &line2);

	if(!status) {

		status = CreateLineMiddleToMiddle(line1, line2, &newLine1);
		if(status || !newLine1)
			AfxMessageBox("CreateLineMiddleToMiddle failed");

		if(CommitToProDESKTOP("CreateLineMiddleToMiddle"))
			return;
	}
	else
		AfxMessageBox("GetCreateLineMiddleToMiddleInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCreateLineMiddleToEnd() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ILine *newLine1 = NULL;

	ILine *line1 = NULL;
	ILine *line2 = NULL;

	status = GetCreateLineMiddleToEndInput(&line1, &line2);

	if(!status) {

		status = CreateLineMiddleToEnd(line1, line2, &newLine1);
		if(status || !newLine1)
			AfxMessageBox("CreateLineMiddleToEnd failed");

		if(CommitToProDESKTOP("CreateLineMiddleToEnd"))
			return;
	}
	else
		AfxMessageBox("GetCreateLineMiddleToEndInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCreateLineEndToStart() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ILine *newLine1 = NULL;

	ILine *line1 = NULL;
	ILine *line2 = NULL;

	status = GetCreateLineEndToStartInput(&line1, &line2);

	if(!status) {

		status = CreateLineEndToStart(line1, line2, &newLine1);
		if(status || !newLine1)
			AfxMessageBox("CreateLineEndToStart failed");

		if(CommitToProDESKTOP("CreateLineEndToStart"))
			return;
	}
	else
		AfxMessageBox("GetCreateLineEndToStartInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCreateLineEndToMiddle() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ILine *newLine1 = NULL;

	ILine *line1 = NULL;
	ILine *line2 = NULL;

	status = GetCreateLineEndToMiddleInput(&line1, &line2);

	if(!status) {

		status = CreateLineEndToMiddle(line1, line2, &newLine1);
		if(status || !newLine1)
			AfxMessageBox("CreateLineEndToMiddle failed");

		if(CommitToProDESKTOP("CreateLineEndToMiddle"))
			return;
	}
	else
		AfxMessageBox("GetCreateLineEndToMiddleInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCreateLineEndToEnd() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ILine *newLine1 = NULL;

	ILine *line1 = NULL;
	ILine *line2 = NULL;

	status = GetCreateLineEndToEndInput(&line1, &line2);

	if(!status) {

		status = CreateLineEndToEnd(line1, line2, &newLine1);
		if(status || !newLine1)
			AfxMessageBox("CreateLineEndToEnd failed");

		if(CommitToProDESKTOP("CreateLineEndToEnd"))
			return;
	}
	else
		AfxMessageBox("GetCreateLineEndToEndInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCreateLineCenterToStart() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ILine *newLine1 = NULL;

	ILine *circle1 = NULL;
	ILine *line1 = NULL;

	status = GetCreateLineCenterToStartInput(&circle1, &line1);

	if(!status) {

		status = CreateLineCenterToStart(circle1, line1, &newLine1);
		if(status || !newLine1)
			AfxMessageBox("CreateLineCenterToStart failed");

		if(CommitToProDESKTOP("CreateLineCenterToStart"))
			return;
	}
	else
		AfxMessageBox("GetCreateLineCenterToStartInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCreateLineCenterToMiddle() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ILine *newLine1 = NULL;

	ILine *circle1 = NULL;
	ILine *line1 = NULL;

	status = GetCreateLineCenterToMiddleInput(&circle1, &line1);

	if(!status) {

		status = CreateLineCenterToMiddle(circle1, line1, &newLine1);
		if(status || !newLine1)
			AfxMessageBox("CreateLineCenterToMiddle failed");

		if(CommitToProDESKTOP("CreateLineCenterToMiddle"))
			return;
	}
	else
		AfxMessageBox("GetCreateLineCenterToMiddleInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCreateLineCenterToEnd() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ILine *newLine1 = NULL;

	ILine *circle1 = NULL;
	ILine *line1 = NULL;

	status = GetCreateLineCenterToEndInput(&circle1, &line1);

	if(!status) {

		status = CreateLineCenterToEnd(circle1, line1, &newLine1);
		if(status || !newLine1)
			AfxMessageBox("CreateLineCenterToEnd failed");

		if(CommitToProDESKTOP("CreateLineCenterToEnd"))
			return;
	}
	else
		AfxMessageBox("GetCreateLineCenterToEndInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCreateLineStartToCenter() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ILine *newLine1 = NULL;

	ILine *line1 = NULL;
	ILine *circle1 = NULL;

	status = GetCreateLineStartToCenterInput(&line1, &circle1);

	if(!status) {

		status = CreateLineStartToCenter(line1, circle1, &newLine1);
		if(status || !newLine1)
			AfxMessageBox("CreateLineStartToCenter failed");

		if(CommitToProDESKTOP("CreateLineStartToCenter"))
			return;
	}
	else
		AfxMessageBox("GetCreateLineStartToCenterInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCreateLineMiddleToCenter() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ILine *newLine1 = NULL;

	ILine *line1 = NULL;
	ILine *circle1 = NULL;

	status = GetCreateLineMiddleToCenterInput(&line1, &circle1);

	if(!status) {

		status = CreateLineMiddleToCenter(line1, circle1, &newLine1);
		if(status || !newLine1)
			AfxMessageBox("CreateLineMiddleToCenter failed");

		if(CommitToProDESKTOP("CreateLineMiddleToCenter"))
			return;
	}
	else
		AfxMessageBox("GetCreateLineMiddleToCenterInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCreateLineEndToCenter() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ILine *newLine1 = NULL;
	ILine *line1 = NULL;
	ILine *circle1 = NULL;

	status = GetCreateLineEndToCenterInput(&line1, &circle1);

	if(!status) {

		status = CreateLineEndToCenter(line1, circle1, &newLine1);
		if(status || !newLine1)
			AfxMessageBox("CreateLineEndToCenter failed");

		if(CommitToProDESKTOP("CreateLineEndToCenter"))
			return;
	}
	else
		AfxMessageBox("GetCreateLineEndToCenterInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnCreateLineCenterToCenter() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = NOERROR;
	ILine *newLine1 = NULL;

	ILine *circle1 = NULL;
	ILine *circle2 = NULL;

	status = GetCreateLineCenterToCenterInput(&circle1, &circle2);

	if(!status){

		status = CreateLineCenterToCenter(circle1, circle2, &newLine1);
		if(status || !newLine1)
			AfxMessageBox("CreateLineCenterToCenter failed");

		if(CommitToProDESKTOP("CreateLineCenterToCenter"))
			return;
	}
	else
		AfxMessageBox("GetCreateLineCenterToCenterInput failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnGearDesign() 
{
	if (GetHelmProDESKTOP()) 
		return;

	HRESULT status = GearDesign();
	if(status)
		AfxMessageBox("GearDesign failed");

	if (ReleaseHelmProDESKTOP()) 
		return;
}

void CCOMClientView::OnUpdateRun(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->Enable(runDw);
}

void CCOMClientView::OnUpdateClosedw(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->Enable(closeDw);
}
